/*
**
** ---> read_ini_file.h <---
**
** Header file for read_ini_file.c, a small collection of functions for reading INI-files.
**
** B. Ulmann fecit SEP-2002.
**
*/

/*
**
** defines for the read_ini_file module
**
*/

#define INI$SUCCESS              0
#define INI$FILE_OPEN_ERROR      1
#define INI$ILLEGAL_LINE_READ    2
#define INI$ILLEGAL_SECTION_READ 3
#define INI$EMPTY_FILE           4
#define INI$OUT_OF_MEMORY        5
#define INI$DEFAULT_USED         6

#define INI$SECTION 0
#define INI$LINE    1

#define INI$COMMENT_CHAR ';'
#define INI$EQUAL_CHAR   '='

/*
**
** typedefs, etc. 
**
*/

typedef struct read_ini_file$config_list
{
  int type;
  char name [STRING_LENGTH], value [STRING_LENGTH];
  struct read_ini_file$config_list *next;
} read_ini_file$ini_list;

/*
**
** function prototypes
**
*/

void dump_ini_file ();

int read_ini_file (char *),
  get_ini_entry (char *, char *, char *, char *);
